/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.util;

public class WavFormatHeader {
    private static final int WAVE_FORMAT_PCM = 1;
    private static final int WAVE_FORMAT_EXTENSIBLE = 65534;
    private boolean isValid = false;
    private int format;
    private int channels;
    private int sampleRate;
    private int bytesPerSecond;
    private int bitsPerSample;
    private int validBitsPerSample;
    private int channelMask;
    private int subFormat;

    public WavFormatHeader(byte[] b) {
        String fmt = new String(b, 0, 3);
        this.format = this.u(b[9]) * 256 + this.u(b[8]);
        if (fmt.equals("fmt") && (this.format == 1 || this.format == 65534)) {
            this.channels = b[10];
            this.sampleRate = this.u(b[15]) * 0x1000000 + this.u(b[14]) * 65536 + this.u(b[13]) * 256 + this.u(b[12]);
            this.bytesPerSecond = this.u(b[19]) * 0x1000000 + this.u(b[18]) * 65536 + this.u(b[17]) * 256 + this.u(b[16]);
            this.bitsPerSample = this.u(b[22]);
            if (this.format == 65534 && this.u(b[24]) == 22) {
                this.validBitsPerSample = this.u(b[26]);
                this.channelMask = this.u(b[31]) * 0x1000000 + this.u(b[20]) * 65536 + this.u(b[29]) * 256 + this.u(b[28]);
                this.subFormat = this.u(b[33]) * 256 + this.u(b[32]);
            }
            this.isValid = true;
        }
    }

    public boolean isExtensible() {
        return this.format == 65534;
    }

    public int getFormat() {
        return this.format;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getChannelMask() {
        return this.channelMask;
    }

    public int getSubFormat() {
        return this.subFormat;
    }

    public int getValidBitsPerSample() {
        return this.validBitsPerSample;
    }

    public int getChannelNumber() {
        return this.channels;
    }

    public int getSamplingRate() {
        return this.sampleRate;
    }

    public int getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    private int u(int n) {
        return n & 0xFF;
    }

    public String toString() {
        String out = "RIFF-WAVE Header:\n";
        out = out + "Is valid?: " + this.isValid;
        return out;
    }
}

